% Applied Machine Learning class - Learning Algorithms and Systems
% Laboratory, EPFL
% Demo Code and Images by Aude Billard, 2024
%
% Original ICA Code by David Gleich, 2003
% http://www.stanford.edu/~dgleich/projects/pca_neural_nets_website/

close all; clear all;
%% Load images
saveSteps = false;
f1 = rgb2gray(imread('greyscale1.jpg'));
f2 = rgb2gray(imread('greyscale2.jpg'));

res = [150 200];
f1 = imresize(f1, res, 'bicubic');
f2 = imresize(f2, res, 'bicubic');

figure(1);clf; hold on;
title('Sources S1, S2');
montage([f1, f2]);


figure(2);clf; hold on;
subplot(1,2,1); hold on;
h1 = histogram(f1);
 txt=['Kurtosis:' num2str(kurtosis(reshape(f1,1,[])))];
 text(1,2000,txt);
  txt=['Entropy:' num2str(entropy(reshape(f1,1,[])))];
 text(1,2100,txt);
title('Distribution Sources S1');
subplot(1,2,2); hold on;
h2 = histogram(f2);
 txt=['Kurtosis:' num2str(kurtosis(reshape(f2,1,[])))];
 text(1,2000,txt);
  txt=['Entropy:' num2str(entropy(reshape(f2,1,[])))];
 text(1,2100,txt);
title('Distribution Sources S2');

%% Plot kurtosis
close all; clear all;

x=[-3.9:0.01:3.9];

figure(1); hold on;

for i=1:4
    y(i)=kurtosis((1/sqrt(2*pi))*exp(-abs(x.^i)),0)-3.0;
    plot(x,(1/sqrt(2*pi))*exp(-abs(x).^i));
end;
axis([-4 4 0 0.4])

legend(['Kurtosis: ' num2str(y(1))],['Kurtosis: ' num2str(y(2))],['Kurtosis: ' num2str(y(3))],['Kurtosis: ' num2str(y(4))])


%% Plot correlated distribution
% close all; clear all;
% 
% s(1,:)=[-1:0.01:1];
% s(2,:)=[-1:0.01:1];
% 
% 
% pd(1,:) = makedist('Uniform')
% pd(2,;) = makedist('Uniform')
% 
% 
% 
% figure(1); hold on;
% subplot(1,2,1);
% plot(pd);
% 
% A=[1   0 
%    2   1]
% 
% subplot(1,2,2);
% x=A*s;
% plot(x);
% 
